<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.sec.gov/edgar/ta/tatwofiler">

	<xsl:import href="util.xsl" />
	<xsl:output method="html" indent="no" encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:variable name="submissionType"
		select="p:edgarSubmission/p:headerData/p:submissionType" />
	<xsl:variable name="schemaVersion" select="p:edgarSubmission/p:schemaVersion" />

	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />
				<style>
					.warning {
						font-weight:bold;   
						padding:10px; 
						margin:5px 0px;
						font-size:0.9em;
					}
					/* informations */
					.information, .informationNoBorder {
						font-weight:lighter   
						padding:10px; 
						color:#302000;
						font-size:0.9em;
					}
					img {
						vertical-align:text-top;
					}
					.information {
						margin:5px 0px;
					}
					.informationNoBorder{
						margin:5px 0px; 
					}
					/* titles (order by font size)*/
					.title1, .title2, .title3, .titleNumber {
						font-family: Arial, Helvetica, sans-serif;
					    text-align: left;
					    line-height: 1.5;					
					}									
					.title1 { /* Largest title */
						margin: 10px 0px;
					    font-size: 1.3em;
					}
					.title2 { /* Second largest title */
						margin: 10px;
					    font-size: 1.1em;
					}	
					.title3 { /* Third largest title */
						margin: 10px 20px;
					    color: black;
					    font-size: 1.0em;
					}
					.titleNumber {
						margin: 10px 0px;
						line-height: 0.8;
					}
					.titleWhite {
						background-color: white;
						width: 25%;
					}
					h4{
						vertical-align:middle;
					}
					.pageHeader {
						font-weight:bold;   
						padding:10px; 
						margin:5px 0px;
						background-color:#e0e0ff;
						border:2px solid #42638F;
						color:#302000;
						text-align: center;
						vertical-align: middle;					
					}				
					#pageHeaderTitle {
						font-size:1.2em;
					}
					#pageHeaderDetail {
						font-size:1.1em;
					}
					#pageHeaderQuestion{
						font-weight:lighter;
						font-size:1.0em;
					}
					#twoHeaders .title1, .title2{
						display:inline;
					}
					#pageHeaderTitleOMB{
						font-size:1.0em;
					}
					#pageHeaderOMBNumber {
						font-size:0.9em;
					}
					#pageHeaderOMBEst {
						font-size:0.8em;
					}
					#ombHeaderTable {
						border-collapse: collapse;
						border:2px solid #42638F;
					}
					#ombHeaderTable td {
						vertical-align: middle;
					}
					#header .side {
						font-weight:lighter;
					}
					.fakeBox {
						border-top: 2px solid #999;
					}
					ul{
						padding-left:10px;
						padding-right:10px;
					}
					.fakeBox_drp1_duration{
						display:inline-block;
						border-top: 2px solid #999;
						border-right: 1px solid #ccc;
						border-bottom: 1px solid #ccc;
						border-left: 2px solid #999;
						padding: 2px;
						min-width: 40px;
						width: 40px;
						height: 15px;
						word-wrap: break-word;
						font-size: 0.9em;
						color: blue;
					}
				</style>
			</head>
		</html>
		<xsl:apply-templates select="p:edgarSubmission/p:headerData/p:filerInfo" />
		<xsl:apply-templates select="p:edgarSubmission"/>
	</xsl:template>

	<!-- Header Template START -->
	<xsl:template name="header"
		match="p:edgarSubmission/p:headerData/p:filerInfo">
		<div id="info">
			<div class="contentwrapper">
				<table role="presentation" id="header">
						<tr>
							<td class="title">Form TA-2 Filer Information</td>
							<td rowspan="2" class="center">			
									<br/>
									UNITED STATES
									<br/>
									SECURITIES AND EXCHANGE COMMISSION
									<br/>
									Washington, D.C. 20549
									<br/><br/>
									FORM <xsl:value-of select="$submissionType"/>											
							</td>
							<td class="title">OMB APPROVAL</td>
						</tr>
						<tr>
						   <td class="side" style="text-align: center;">
									<p>
										<br/><br/><br/>
										<br/><br/><br/>
										FORM <xsl:value-of select="$submissionType"/>
										<br/><br/><br/>
										<br/><br/><br/>
									</p>
							</td>
							<td
									width="25%"
									class="side">					
									<p>OMB Number:&#160;&#160; 3235-0337</p>
									<br/>
									<p>Estimated average burden hours per response: 6.0</p>
									<br/>
									<p>Estimated average burden hours per intermediate response: 1.50</p>
									<br/>
									<p>Estimated average burden hours per minimum response: 0.50</p>
							</td>
						</tr>
					</table>
				<div class="content">
					<h1>
						<xsl:value-of select="$submissionType"/>: Filer Information
					</h1>
					<table role="presentation" class="filerInformation">
						<tr>
							<td class="label"><b>1(a).</b> Filer CIK:</td>
							<td>
								<div class="fakeBox2">
								<xsl:call-template name="CIKLink" >
									<xsl:with-param name="aCIK" select="p:filer/p:filerCredentials/p:cik"></xsl:with-param>
									<xsl:with-param name="label" select="p:filer/p:filerCredentials/p:cik"></xsl:with-param>									
								</xsl:call-template>
								</div>						
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(b).</b> Filer CCC:</td>
							<td>
								<div class="fakeBox2">
								**********
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">File Number: </td>
							<td>
							<div class="fakeBox2">
								<xsl:call-template name="FileNoLink" >
									<xsl:with-param name="aFileNumber" select="p:filer/p:fileNumber"></xsl:with-param>
									<xsl:with-param name="label" select="p:filer/p:fileNumber"></xsl:with-param>									
								</xsl:call-template>
							</div>
							</td>
						</tr>
						<tr>
							<td class="label">For the reporting period ending December 31, </td>
							<td>
								<div class="fakeBox2">
								 <xsl:value-of select="p:periodOfReport" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(c).</b> Is this a LIVE or TEST Filing?</td>
							<td>							
								<xsl:choose>
									<xsl:when test="p:testOrLive = 'LIVE'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								&#160;LIVE
								<xsl:choose>
									<xsl:when test="p:testOrLive = 'TEST'">
										<img src="Images/radio-checked.jpg" alt="radio button checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
									</xsl:otherwise>
								</xsl:choose>
								&#160;TEST							
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(d).</b> Would you like a Return Copy?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:flags/p:returnCopy = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(e).</b> Is this filing an amendment to a previous filing?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:flags/p:isFilingAmendment = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>	
					</table>
					<p></p>
					<h3>Submission Contact Information</h3>	
					<table role="presentation">
						<tr>
							<td>
								The registrant may provide a single e-mail address for contact purposes.
							</td>
						</tr>						
					</table>										
                <table role="presentation">
						<tr>
							<td class="label"><b>1(f)(i).</b> Contact Name:</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="p:contactData/p:contactName" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label"><b>1(f)(ii).</b> Contact Phone Number:</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="p:contactData/p:contactPhoneNumber" />
								</div>
							</td>
						</tr>

						<tr>
							<td class="label"><b>1(f)(iii).</b> Contact E-Mail Address:</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="p:contactData/p:contactEmailAddress" />
								</div>
							</td>
						</tr>
					</table>	
					<p></p>	
					<h3>Notification Information</h3>				
					<table role="presentation">
						<tr>
							<td>
								Notification will automatically be sent to the Login CIK, Submission Contact and Primary Registrants.
							</td>
						</tr>						
						<tr>
							<td>
								The registrant may provide additional e-mail addresses for those 
								persons the filer would like to receive notification e-mails regarding the filing.
							</td>
						</tr>						
					</table>
					<table role="presentation">											
						<tr>
							<td
								class="label">
								<b>1(g).</b> Notification E-mail Address:
													</td>
							<td>
								<xsl:for-each
									select="p:notificationAddresses/p:notificationEmailAddress">
									<div
										class="fakeBox">
										<xsl:value-of
											select="." />
									</div>
									<br />
								</xsl:for-each>
							</td>
						</tr>
					
						<tr>
							<td
								class="label"><b>1(h).</b> Full Name of Registrant as stated in Question 3 of
								Form TA-1:
							</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="p:entityName" />
								</div>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>	
	
	<xsl:template name="formData" match="p:edgarSubmission">
		<xsl:call-template name="item1_serviceCompanyInfo" />
		<xsl:call-template name="item2_registrationInfo" />
		<xsl:call-template name="item3_annualReportInfo" />
		<xsl:call-template name="item4_signature" />
	</xsl:template>

	<xsl:include href="TA-2_item1.xsl" />
	<xsl:include href="TA-2_item2.xsl" />
	<xsl:include href="TA-2_item3.xsl" />
	<xsl:include href="TA-2_item4.xsl" />
	<xsl:include href="SDR_State_Codes.xsl" />
</xsl:stylesheet>